// test-key.js
const axios = require("axios");

// 🔴 PASTE YOUR API KEY DIRECTLY BETWEEN THE QUOTES BELOW
const MY_API_KEY =
  "ZXlKaGJHY2lPaUpJVXpVeE1pSXNJblI1Y0NJNklrcFhWQ0o5LmV5SmpiR0Z6Y3lJNklrMWxjbU5vWVc1MElpd2ljSEp2Wm1sc1pWOXdheUk2TVRVMU9EVXNJbTVoYldVaU9pSXhOelk0TVRZME5qazRMalEzTURBeE5TSjkuazE2VHl6MzAzclZRZEVpMllybWE1YnhOVGVMQ0hJdDNGQjhuTk9maXRVX0Qtem5FSHZQQmRNaDV3RVdmXzJUbDZfU2Nza2ZHcWZTdV91Mmp6U3UzSGc=";

async function testConnection() {
  console.log("---------------------------------------------------");
  console.log("🧪 TESTING PAYMOB API KEY...");
  console.log(`🔑 Key Length: ${MY_API_KEY.length} characters`);
  console.log("---------------------------------------------------");

  try {
    const response = await axios.post(
      "https://accept.paymob.com/api/auth/tokens",
      {
        api_key: MY_API_KEY,
      }
    );

    console.log("✅ SUCCESS! The Key is working.");
    console.log(
      "🎟️  Token received:",
      response.data.token.substring(0, 20) + "..."
    );
    console.log("---------------------------------------------------");
  } catch (error) {
    console.log("❌ FAILED.");
    if (error.response) {
      console.log("🚫 Status Code:", error.response.status); // 401 or 403 means Wrong Key
      console.log(
        "🚫 Error Message:",
        JSON.stringify(error.response.data, null, 2)
      );
    } else {
      console.log("🚫 Network Error:", error.message);
    }
    console.log("---------------------------------------------------");
    console.log("👉 If Status is 401/403: The Key is 100% invalid or revoked.");
    console.log(
      "👉 Please go to Dashboard > Settings > API Keys and generate a new one."
    );
  }
}

testConnection();
